<?php
/*******************************************************************************
 *	JAPRO Template Engine
 *     Ver. 2.1.2
 *
 *	ex.
 *
 *	$jte = new JTE() ;
 *	$template->exexute( 'template/sample.html', $data ) ;
 *
 *******************************************************************************/

if ( mb_ereg( '^4\.', phpversion() ) ) {
	require( dirname( __FILE__ ) . '/jte_dom.php' ) ;
} else {
	if ( class_exists( 'DOMDocument' ) ) {
		class jte_DOMDocument extends DOMDocument {}
	} else {
		require( dirname( __FILE__ ) . '/jte_dom.php' ) ;
	}
}


class jte {
	var $templateAttribute = 'jte' ;
	
	var $encoding = 'UTF-8' ;
	var $doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' ;
	var $xhtml ;
	var $dom ;
	
	var $data ;
	
	var $emptyTag = array(
		'meta',
		'base',
		'link',
		'basefont',
		'spacer',
		'br',
		'wbr',
		'hr',
		'img',
		'area',
		'param',
		'bgsound',
		'input'
	) ;
	
	var $blankAttribute = array(
		'checked',
		'compact',
		'declare',
		'defer',
		'disabled',
		'ismap',
		'multiple',
		'nohref',
		'noresize',
		'noshade',
		'nowrap',
		'selected',
		'target'
	) ;
	
	var $urlAttribute = array(
		'href',
		'src',
		'background',
		'cite',
		'action'
	) ;
	
	var $cache_use = false ;
	var $cache_dir = 'cache/' ;
	
	var $log = false ;
	var $log_file = 'jte.log' ;
	
	
	//==================================================================
	// constructor
	
	function jte() {
		$this->__construct() ;
	}
	
	
	function __construct() {
		$this->data = array(
			'condition'	=> array(),
			'value'		=> array(),
			'record'	=> array(),
			'function'	=> array()
		) ;
	}
	
	
	//==================================================================
	// set all
	
	function set( $data ) {
		if ( isset( $data[ 'function' ] ) ) {
			$this->set_functions( $data[ 'function' ] ) ;
		}
		
		if ( isset( $data[ 'condition' ] ) ) {
			$this->set_conditions( $data[ 'condition' ] ) ;
		}
		
		if ( isset( $data[ 'value' ] ) ) {
			$this->set_values( $data[ 'value' ] ) ;
		}
		
		if ( isset( $data[ 'record' ] ) ) {
			$this->set_records( $data[ 'record' ] ) ;
		}
	}
	
	
	//==================================================================
	// set with hash
	
	function set_functions( $hash ) {
		foreach ( $hash as $name => $function ) {
			$this->set_function( $name, $function ) ;
		}
	}
	
	
	function set_conditions( $hash ) {
		foreach ( $hash as $name => $flag ) {
			$this->set_condition( $name, $flag ) ;
		}
	}
	
	
	function set_values( $hash ) {
		foreach ( $hash as $name => $value ) {
			$this->set_value( $name, $value ) ;
		}
	}
	
	
	function set_records( $hash ) {
		foreach ( $hash as $name => $record ) {
			$this->set_record( $name, $record ) ;
		}
	}
	
	
	//==================================================================
	// set
	
	function set_function( $name, $function ) {
		$this->data[ 'function' ][ $name ] = $function ;
	}
	
	
	function set_condition( $name, $flag ) {
		$this->data[ 'condition' ][ $name ] = ( $flag ) ? true : false ;
	}
	
	
	function set_value( $name, $value ) {
		$this->data[ 'value' ][ $name ] = $value ;
	}
	
	
	function set_record( $name, $record ) {
		$this->data[ 'record' ][ $name ] = $record ;
	}
	
	
	//==================================================================
	// load template
	
	function load( $path ) {
		if ( $this->cache_load( $path ) ) return true ;
		
		$html = @file_get_contents( $path ) ;
		
		if ( $html === false ) return false ;
		
		$html = $this->delete_bom( $html ) ;
		
		$this->dom = new jte_DOMDocument( '1.0' ) ;
		$this->dom->encoding = $this->encoding ;
		$this->dom->validate = true ;
		
		$html = trim( $html ) ;
		
		if ( mb_eregi( '\A(<\?xml\s+.*?\?>)\s*(.*)\z', $html, $part ) ) {
			$html = $part[ 2 ] ;
		}
		
		if ( mb_ereg( '\A(<\!DOCTYPE\s+.*?>)\s*(.*)\z', $html, $part ) ) {
			$this->doctype = $part[ 1 ] ;
			$html = $part[ 2 ] ;
		}
		
		if ( ! mb_eregi( '\A<html(\s+.*?)?>', $html ) ) {
			echo "No html !! " . htmlspecialchars( mb_substr( $html, 0, 20 ) ) . "...<br />\n" ;
			return false ;
		}
		
		$this->_parse( $this->dom, $html ) ;
		
		$this->cache_save( $path ) ;
		
		return true ;
	}

	
	function cache_load( $path ) {
		if ( ! mb_ereg( '^4\.', phpversion() ) ) return false ;
		if ( ! $this->cache_use ) return false ;
		
		$path_cache = realpath( $this->cache_dir ) . '/' . urlencode( $path ) ; 
		
		if ( file_exists( $path_cache ) ) {
			if (  filemtime( $path ) < filemtime( $path_cache ) ) return false ;
		}
		
		$cache = @file_get_contents( $path_cache ) ;
		
		if ( $cache === false ) return false ;
		
		$this->dom = unserialize( $cache ) ;
		
		return true ;
	}

	
	function cache_save( $path ) {
		if ( ! mb_ereg( '^4\.', phpversion() ) ) return false ;
		if ( ! $this->cache_use ) return false ;
		
		$path_cache = realpath( $this->cache_dir ) . '/' . urlencode( $path ) ; 
		
		if ( file_exists( $path_cache ) ) {
			if (  filemtime( $path ) < filemtime( $path_cache ) ) return false ;
		}
		
		$cache = serialize( $this->dom ) ;
		
		@file_put_contents( $path_cache, $cache ) ;
		
		return ;
	}
	
	
	//==================================================================
	// _parse
	
	function _parse( &$parent, &$html, $open = '' ) {
		while ( $html != '' ) {
			if ( ! mb_ereg( '\A(.*?)(<.*?>)(.*)\z', $html, $match ) ) {
				$parent->appendChild( $this->dom->createTextNode( $html ) ) ;
				$html = '' ;
				break ;
			}
			
			$text = $match[ 1 ] ;
			$tag = $match[ 2 ] ;
			$html = $match[ 3 ] ;
			
			if ( $text != '' ) {
				$parent->appendChild( $this->dom->createTextNode( $text ) ) ;
			}
			
			if ( mb_ereg( '\A\<\!--(.*?)--\>(.*)\z', $tag, $match ) ) {
				$text = $match[ 1 ] ;
				$parent->appendChild( $this->dom->createComment( $text ) ) ;
				continue ;
			}
			
			if ( mb_ereg( '\A\<\!\[CDATA\[(.*?)\]\]\>(.*)\z', $tag, $match ) ) {
				$text = $match[ 1 ] ;
				$parent->appendChild( $this->dom->createCDATASection( $text ) ) ;
				continue ;
			}
			
			if ( mb_ereg( '\A<\/\s*(.*?)\s*>\z', $tag, $match ) ) {
				$tagName = strtolower( $match[ 1 ] ) ;
				
				if ( ( $open == '' ) or ( $open != $tagName ) ){
					echo "Not opened or invalid &lt;{$open}&gt; - &lt;/{$tagName}&gt;<br />\n" ;
				}
				
				break ;
			}
			
			$this->_parse_element( $parent, $tag, $html ) ;
		}
	}
	
	
	function _parse_element( &$parent, $tag, &$html ) {
		if ( ! mb_ereg( '\A<\s*(\S+)\s*(.*)>\z', $tag, $match ) ) {
			// <理解不能>
			return ;
		}
		
		$tagName = strtolower( $match[ 1 ] ) ;
		$attributes = $match[ 2 ] ;
		$closed = false ;
		
		if ( mb_ereg( '\A(.*?)\s*( ?\/)\z', $attributes, $match ) ) {
			$attributes = $match[ 1 ] ;
			$closed = true ;
		}
		
		$node = $this->dom->createElement( $tagName ) ;
		$this->_parse_attributes( $node, $attributes ) ;
		
		if ( ! $closed ) {
			if ( ! in_array( $tagName, $this->emptyTag ) ) {
				if ( $tagName == 'script' ) {
					if ( mb_eregi( '\A(.*?)<\/\s*script\s*>(.*)\z', $html, $match ) ) {
						$text = $match[ 1] ;
						$html = $match[ 2 ] ;
						
						if ( $text != '' ) {
							$node->appendChild( $this->dom->createTextNode( $text ) ) ;
						}
					} else {
						if ( $html != '' ) {
							$node->appendChild( $this->dom->createTextNode( $html ) ) ;
						}
						
						$html = '' ;
					}
				} else {
					$this->_parse( $node, $html, $tagName ) ;
				}
			}
		}
		
		$parent->appendChild( $node ) ;
		
		return true ;
	}
	
	
	function _parse_attributes( &$node, &$attributes ) {
		while ( $attributes != '' ) {
			if ( mb_ereg( '\A(\S+?)\s*=\s*("[^"]*"|\'[^\']*\'|\S+)\s*(.*?)\s*\z', $attributes, $match ) ) {
				$name = strtolower( $match[ 1 ] ) ;
				$value = $match[ 2 ] ;
				$attributes = $match[ 3 ] ;
				
				if ( $node->hasAttribute( $name ) ) {
					continue ;
				}
				
				if ( mb_ereg( '\A"([^"]*)"\z', $value, $match ) ) {
					$value = $match[ 1 ] ;
				} else {
					if ( mb_ereg( '\A\'([^\']*)\'\z', $value, $match ) ) {
						$value = $match[ 1 ] ;
						
						if ( in_array( $name, $this->urlAttribute ) ) {
							$value = mb_ereg_replace( '"', '%22', $value ) ;
						} else {
							$value = mb_ereg_replace( '"', '&quot;', $value ) ;
						}
					}
				}
				
				$node->setAttribute( $name, $value ) ;
				
				continue ;
			}
			
			if ( mb_ereg( '\A(\S*)\s*(.*?)\s*\z', $attributes, $match ) ) {
				$name = strtolower( $match[ 1 ] ) ;
				$attributes = $match[ 2 ] ;
				
				if ( $node->hasAttribute( $name ) ) {
					continue ;
				}
				
				$node->setAttribute( $name, $name ) ;
				
				continue ;
			}
			
			break ;
		}
	}
	
	
	//==================================================================
	// replace template by data
	
	function replace() {
		$this->tagEnd = ( $this->xhtml ) ? ' /' : '' ;
		
		$this->data[ 'root' ] = &$this->data ;
		
		$this->data[ 'parent' ] = array(
			'condition'	=> array(),
			'value'		=> array(),
			'record'	=> array(),
			'function'	=> array()
		) ;
		
		$records = array() ;
		
		$this->replace_element( $this->dom->documentElement, $this->data, $records, false ) ;
		
		foreach ( $records as $name => $record ) {
			$this->replace_record( $record ) ;
		}
	}
	
	
	//==================================================================
	// replace_element
	
	// 0. (not jte attribute) (child) (exit)
	// 1. (not record) fake (exit)
	// 2. (not record) record (recall element)
	// 3. (not record) if/else (exit)
	// 4. (not record) parse_outer (recall each element)
	// 5. (not record) outer (exit)
	// 6. attribute
	// 7. function
	// 8. text, textarea (exit)
	// 9. inner (exit)
	// 10. parse_inner
	// 11. (child)
	
	function replace_element( &$element, &$data, &$records, $in_record = false, $is_record = false ) {
		
		// replace ?
		
		if ( ! $element->hasAttribute( $this->templateAttribute ) ) {
			$this->replace_childs( $element, $data, $records, $in_record ) ;
			return ;
		}
		
		$commands = $this->_get_template_commands( $element ) ;
		
		if ( ! $is_record ) {
			
			// fake
			
			if ( isset( $commands[ 'fake' ] ) ) {
				$this->replace_remove( $element ) ;
				return ;
			}
			
			// record -> replace_child
			
			if ( isset( $commands[ 'record' ] ) ) {
				$name = $commands[ 'record' ] ;
				list( $local, $localName ) = $this->_get_template_value_local( $data, $name ) ;
				
				if ( isset( $local[ 'record' ] ) ) {
					if ( isset( $local[ 'record' ][ $localName ] ) ) {
						if ( count( $local[ 'record' ][ $localName ] ) > 0 ) {
							if ( ! isset( $records[ $name ] ) ) {
								$records[ $name ] = array(
									'data'		=> $local[ 'record' ][ $localName ],
									'elements'	=> array()
								) ;
							}
							
							if ( count( $records[ $name ][ 'elements' ] ) < count( $records[ $name ][ 'data' ] ) ) {
								$n = count( $records[ $name ][ 'elements' ] ) ;
								
								$records[ $name ][ 'data' ][ $n ][ 'root' ] =& $this->data ;
								$records[ $name ][ 'data' ][ $n ][ 'parent' ] =& $data ;
								
								$records[ $name ][ 'elements' ][] = array(
									'element'	=> &$element,
									'records'	=> array()
								) ;
								
								$this->replace_element(
									$records[ $name ][ 'elements' ][ $n ][ 'element' ],
									$records[ $name ][ 'data' ][ $n ],
									$records[ $name ][ 'elements' ][ $n ][ 'records' ],
									true,
									true
								) ;
								
								return ;
							}
						}
					}
				}
				
				$this->replace_remove( $element ) ;
				return ;
			}
			
			// if/else
			
			if ( isset( $commands[ 'condition' ] ) ) {
				for ( $n = 0 ; $n < count( $commands[ 'condition' ] ) ; $n++ ) {
					$check = false ;
					
					$condition = $commands[ 'condition' ][ $n ][ 'condition' ] ;
					$name = $commands[ 'condition' ][ $n ][ 'name' ] ;
					
					list( $local, $localName ) = $this->_get_template_value_local( $data, $name ) ;
					
					if ( isset( $local[ 'condition' ][ $localName ] ) ) {
						$check = $local[ 'condition' ][ $localName ] ;
					} else {
						if ( isset( $local[ 'record' ][ $localName ] ) ) {
							$check = ( count( $local[ 'record' ][ $localName ] ) > 0 ) ;
						} else {
							if ( isset( $local[ 'value' ][ $localName ] ) ) {
								$check = ( "{$local[ 'value' ][ $localName ]}" != '' ) ;
							}
						}
					}
					
					if ( $check != $condition ) {
						$this->replace_remove( $element ) ;
						return ;
					}
				}
			}
			
			// parse_outer
			
			if ( isset( $commands[ 'parse_outer' ] ) ) {
				$this->replace_parse_outer( $element, $data, $commands[ 'parse_outer' ], $records, $in_record ) ;
				return ;
			}
			
			// outer
			
			if ( isset( $commands[ 'outer' ] ) ) {
				if ( $in_record ) {
					$this->replace_parse_outer( $element, $data, $commands[ 'outer' ], $records, $in_record ) ;
				}
				
				return ;
			}
		}
		
	    // @ - attribute
	    
		if ( isset( $commands[ '@' ] ) ) {
			for ( $n = 0 ; $n < count( $commands[ '@' ] ) ; $n++ ) {
				$attribute = $commands[ '@' ][ $n ][ 'attribute' ] ;
				$name = $commands[ '@' ][ $n ][ 'name' ] ;
				
				list( $local, $localName ) = $this->_get_template_value_local( $data, $name ) ;
				
				if ( ! isset( $local[ 'value' ][ $localName ] ) ) continue ;
				
				if ( "{$local[ 'value' ][ $localName ]}" == '' ) {
					if ( in_array( $attribute, $this->blankAttribute ) ) {
						if ( $element->hasAttribute( $attribute ) ) {
							$element->removeAttribute( $attribute ) ;
						}
						
						continue ;
					}
				}
				
				$element->setAttribute( $attribute, $local[ 'value' ][ $localName ] ) ;
			}
		}
		
		// other
		
		if ( isset( $commands[ 'other' ] ) ) {
			for ( $n = 0 ; $n < count( $commands[ 'other' ] ) ; $n++ ) {
				$command = $commands[ 'other' ][ $n ][ 'command' ] ;
				$name = $commands[ 'other' ][ $n ][ 'name' ] ;
				
				switch ( $command ) {
					case 'function' :
						list( $local, $localName ) = $this->_get_template_value_local( $data, $name ) ;
						
						if ( isset( $local[ 'function' ][ $localName ] ) ) {
							if ( is_callable( $local[ 'function' ][ $localName ] ) ) {
								call_user_func_array( $local[ 'function' ][ $localName ], array( &$this, &$element, &$data, $command, $name ) ) ;
							}
						}
						
						break ;
					
					default :
						$method = "command_{$command}" ;
						
						if ( method_exists( $this, $method ) ) {
							$replace_child = call_user_func_array( array( $this, $method ), array( &$element, &$data, $command, $name ) ) ;
						}
				}
			}
		}
		
	    // text
	    
		if ( isset( $commands[ 'text' ] ) ) {
			$name = $commands[ 'text' ] ;
			
			list( $local, $localName ) = $this->_get_template_value_local( $data, $name ) ;
			
			if ( isset( $local[ 'value' ][ $localName ] ) ) {
				$br = ( $this->xhtml ) ? '<br />' : '<br>' ;
				
				$html = mb_ereg_replace( "\r?\n", "{$br}\n", htmlspecialchars( $local[ 'value' ][ $localName ] ) ) ;
				
				while ( $element->childNodes->length > 0 ) $element->removeChild( $element->firstChild ) ;
				
				$this->_parse( $element, $html ) ;
			}
			
			return ;
		}
		
		// textarea
	    
		if ( isset( $commands[ 'textarea' ] ) ) {
			$name = $commands[ 'textarea' ] ;
			
			list( $local, $localName ) = $this->_get_template_value_local( $data, $name ) ;
			
			if ( isset( $local[ 'value' ][ $localName ] ) ) {
				$html = htmlspecialchars( $local[ 'value' ][ $localName ] ) ;
			
				while ( $element->childNodes->length > 0 ) $element->removeChild( $element->firstChild ) ;
				
				$this->_parse( $element, $html ) ;
			}
			
			return ;
		}
		
		// inner
		
		if ( isset( $commands[ 'inner' ] ) ) {
			if ( $in_record ) {
				$this->replace_parse_inner( $element, $data, $commands[ 'inner' ], $records, $in_record ) ;
			} else {
				return ;
			}
			
			return ;
		}
		
		// parse_inner
		
		if ( isset( $commands[ 'parse_inner' ] ) ) {
			$this->replace_parse_inner( $element, $data, $commands[ 'parse_inner' ], $records, $in_record ) ;
		}
		
		// childs
		
		$this->replace_childs( $element, $data, $records, $in_record ) ;
	}
	
	
	// replace_childs
	
	function replace_childs( &$element, &$data, &$records, $in_record ) {
		$childs = array() ;
		
		$childNodes =& $element->childNodes ;
		
		for ( $n = 0 ; $n < $childNodes->length ; $n++ ) {
			$child =& $childNodes->item( $n ) ;
			
			if ( $child->nodeType == XML_ELEMENT_NODE ) {
				$childs[] =& $child ;
			}
			
			unset( $child ) ;
		}
		
		for ( $n = 0 ; $n < count( $childs ) ; $n++ ) {
			$this->replace_element( $childs[ $n ], $data, $records, $in_record ) ;
		}
	}
	
	
	//==================================================================
	// replace_record
	
	function replace_record( &$record ) {
		
		// 不足分作成
		
		if ( count( $record[ 'elements' ] ) < count( $record[ 'data' ] ) ) {
			$parent =& $record[ 'data' ][ count( $record[ 'elements' ] ) - 1 ][ 'parent' ] ;
			$last =& $record[ 'elements' ][ count( $record[ 'elements' ] ) - 1 ][ 'element' ] ;
			
			// 追加位置
			
			$anchor = $this->dom->createElement( $last->tagName ) ;
			
			if ( is_null( $last->nextSibling ) ) {
				$last->parentNode->appendChild( $anchor ) ;
			} else {
				$last->parentNode->insertBefore( $anchor, $last->nextSibling ) ;
			}
			
			// 追加材料
			
			$source = array() ;
			
			if ( ! is_null( $last->previousSibling ) ) {
				if ( $last->previousSibling->nodeType == XML_TEXT_NODE ) {
					if ( trim( $last->previousSibling->nodeValue ) == '' ) {
						$source[] = $last->previousSibling->cloneNode() ;
					}
				}
			}
			
			// 追加

			for ( $n = count( $record[ 'elements' ] ) ; $n < count( $record[ 'data' ] ) ; $n++ ) {
				for ( $s = 0 ; $s < count( $source ) ; $s++ ) {
					$anchor->parentNode->insertBefore( $source[ $s ]->cloneNode( true ), $anchor ) ;
				}
				
				$element = $last->cloneNode( true ) ;
				$anchor->parentNode->insertBefore( $element, $anchor ) ;
				
				$record[ 'data' ][ $n ][ 'root' ] =& $this->data ;
				$record[ 'data' ][ $n ][ 'parent' ] =& $parent ;
				
				$record[ 'elements' ][] = array(
					'element'	=> &$element,
					'records'	=> array()
				) ;
				
				$this->replace_element(
					$record[ 'elements' ][ $n ][ 'element' ],
					$record[ 'data' ][ $n ],
					$record[ 'elements' ][ $n ][ 'records' ],
					true,
					true
				) ;
				
				unset( $element ) ;
			}
			
			$anchor->parentNode->removeChild( $anchor ) ;
		}
		
		// 子レコード
		
		for ( $n = 0 ; $n < count( $record[ 'elements' ] ) ; $n++ ) {
			foreach ( $record[ 'elements' ][ $n ][ 'records' ] as $name => $child_records ) {
				$this->replace_record( $record[ 'elements' ][ $n ][ 'records' ][ $name ] ) ;
			}
		}
	}
	
	
	function replace_remove( &$element ) {
		if ( ! is_null( $element->previousSibling ) ) {
			if ( $element->previousSibling->nodeType == XML_TEXT_NODE ) {
				if ( trim( $element->previousSibling->nodeValue ) == '' ) {
					$element->parentNode->removeChild( $element->previousSibling ) ;
				}
			}
		}
		
		$element->parentNode->removeChild( $element ) ;
	}
	
	
	// parse_outer
	
	function replace_parse_outer( &$element, &$data, $name, &$records, $in_record ) {
		$html = $this->_get_template_contents( $data, $name ) ;
		
		if ( $html === false ) {
			return ;
		}
		
		$html = rtrim( $this->delete_bom( $html ) ) ;
		
		// outerHTML & replace
		
		$childs = array() ;
		
		$div = $this->dom->createElement( 'div' ) ;
		
		$this->_parse( $div, $html ) ;
		
		for ( $n = 0 ; $n < $div->childNodes->length ; $n++ ) {
			$child = $div->childNodes->item( $n )->cloneNode( true ) ;
			
			$element->parentNode->insertBefore( $child, $element ) ;
			
			if ( $child->nodeType == XML_ELEMENT_NODE ) {
				$childs[] = &$child ;
			}
			
			unset( $child ) ;
		}
		
		$element->parentNode->removeChild( $element ) ;	
		
		for ( $n = 0 ; $n < count( $childs ) ; $n++ ) {
			$this->replace_element( $childs[ $n ], $data, $records, $in_record ) ;
		}
	}
	
	
	// parse_inner
	
	function replace_parse_inner( &$element, &$data, $name, &$records, $in_record ) {
		$html = $this->_get_template_contents( $data, $name ) ;
		
		if ( $html === false ) {
			return ;
		}
		
		$html = rtrim( $this->delete_bom( $html ) ) ;
		
		$html = $this->_inner_keep_indent( $element, $html ) ;
		
		while ( $element->childNodes->length > 0 ) {
			$element->removeChild( $element->firstChild ) ;
		}
		
		$this->_parse( $element, $html ) ;
	}
	
	
	//==================================================================
	// output html
	
	function save() {
		$this->xhtml = mb_ereg( '\sXHTML\s', $this->doctype ) ;
		
		$html = "{$this->doctype}\n" ;
		
		$this->_tree( $html, $this->dom->documentElement, $this->data ) ;
		
		return $html ;
	}
	
	
	//==================================================================
	// _tree
	
	function _tree( &$html, &$node, $data, $in_record = false ) {
		$xhtml = mb_ereg( '\sXHTML\s', $this->doctype ) ;
		$emptyTagEnd = ( $xhtml ) ? ' />' : '>' ;
		
		if ( $node->nodeType == XML_ELEMENT_NODE ) {
			$tag = array( $node->tagName )   ;
			
			$commands = $this->_get_template_commands( $node ) ;
			$node->removeAttribute( $this->templateAttribute ) ;
			
			if ( ! $in_record ) {
				$in_record = ( isset( $commands[ 'record' ] ) ) ;
			}
			
			if ( ( ! $in_record ) and ( isset( $commands[ 'outer' ] ) ) ) {
				$contents = $this->_get_template_contents( $data, $commands[ 'outer' ] ) ;
				if ( $contents !== false ) $html .= $contents ;
				return ;
			}
			
			$attributes =& $node->attributes ;
			
			for ( $n = 0 ; $n < $attributes->length ; $n++ ) {
				$attribute =& $attributes->item( $n ) ;
				
				$name = $attribute->name ;
				$value = $attribute->value ;
				
				if ( $value == '' ) {
					if ( in_array( $name, $this->blankAttribute ) ) continue ;
				}
				
				if ( $this->xhtml ) {
					$tag[] = htmlspecialchars( $name ) . '="' . $value . '"' ;
				} else {
					if ( in_array( $name, $this->blankAttribute ) ) {
						$tag[] = htmlspecialchars( $name ) ;
					} else {
						$tag[] = htmlspecialchars( $name ) . '="' . $value . '"' ;
					}
				}
			}
			
			if ( in_array( $node->tagName, $this->emptyTag ) ) {
				$html .= "<" . implode( ' ', $tag ) . ( ( $this->xhtml ) ? ' />' : '>' ) ;
			} else {
				$html .= "<" . implode( ' ', $tag ) . ">" ;
				
				if ( ( ! $in_record ) and ( isset( $commands[ 'inner' ] ) ) ){
					$text = $this->_get_template_contents( $data, $commands[ 'inner' ] ) ;
					$text = rtrim( $this->delete_bom( $text ) ) ;
					$text = $this->_inner_keep_indent( $node, $text ) ;
					
					$html .= $text ;
				} else {
					$this->_tree_childs( $html, $node, $data, $in_record ) ;
				}
				
				$html .= "</" . $node->tagName . ">" ;
			}
			
			return ;
		}
		
		if ( $node->nodeType == XML_COMMENT_NODE ) {
			$html .= "<!--" . $node->nodeValue . "-->" ;
			return ;
		}
		
		if ( $node->nodeType == XML_CDATA_SECTION_NODE ) {
			$html .= "<![CDATA[" . $node->nodeValue . "]]>" ;
			return ;
		}
		
		$html .= $node->nodeValue ;
	}
	
	
	function _tree_childs( &$html, &$node, &$data, $in_record = false ) {
		for ( $n = 0 ; $n < $node->childNodes->length ; $n++ ) {
			$this->_tree( $html, $node->childNodes->item( $n ), $data, $in_record ) ;
		}
	}
	
	
	//==================================================================
	// output html from template and data
	
	function execute( $path, $data ) {
		if ( $this->load( $path ) === false ) return false ;
		$this->set( $data ) ;
		$this->replace() ;
		echo $this->save() ;
	}
	
	
	//==================================================================
	// part of html
	
	function part_load( $html ) {
		$html = $this->delete_bom( $html ) ;
		
		$this->dom = new jte_DOMDocument( '1.0' ) ;
		$this->dom->encoding = $this->encoding ;
		
		$part = "<part>" . trim( $html ) . "</part>" ;
		
		$this->_parse( $this->dom, $part ) ;
		
		return true ;
	}
	
	
	function part_replace( $data ) {
		$records = array() ;
		
		$this->replace_childs( $this->dom->documentElement, $data, $records ) ;
		
		foreach ( $records as $name => $record ) {
			$this->replace_record( $record ) ;
		}
	}
	
	
	function part_save( $data, $xhtml = true ) {
		$this->xhtml = $xhtml ;
		
		$html = "" ;
		
		for ( $n = 0 ; $n < $this->dom->documentElement->childNodes->length ; $n++ ) {
			$this->_tree( $html, $this->dom->documentElement->childNodes->item( $n ), $data ) ;
		}
		
		return $html ;
	}
	
	
	function part_execute( $html, $data, $xhtml = true ) {
		$this->part_load( $html ) ;
		$this->part_replace( $data ) ;
		return $this->part_save( $data, $xhtml ) ;
	}
	
	
	//==================================================================
	// common
	
	function log_write( $text ) {
		if ( ! $this->log ) return ;
		
		$fh = fopen( $this->log_file, 'a' ) ;
		fwrite( $fh, date( '[Y-m-d H:i:s] ' ) . $text . "\n" ) ;
		fclose( $fh ) ;
	}
	
	
	function delete_bom( $text ) {
		return mb_ereg_replace( '\A\xef\xbb\xbf', '', $text ) ;
	}
	
	
	function _get_template_commands( &$element ) {
		$attributes = mb_split( '\s*;\s*', trim( $element->getAttribute( $this->templateAttribute ) ) ) ;
		
		$commands = array() ;
		
		for ( $a = 0; $a < count( $attributes ) ; $a++ ) {
			$command_name = trim( $attributes[ $a ] ) ;
			
			if ( $command_name == '' ) continue ;
			
			if ( mb_ereg( '\A([^:]*)\s*:\s*(.*)\z', $command_name, $match ) ) {
				$command = $match[ 1 ] ;
				$name = $match[ 2 ] ;
			} else {
				$command = $command_name ;
				$name = '' ;
			}
			
			if ( mb_ereg( '\A@(.+)\z', $command, $match ) ) {
				$attribute = strtolower( $match[ 1 ] ) ;
				
				if ( ! isset( $commands[ '@' ] ) ) $commands[ '@' ] =  array() ;
				$commands[ '@' ][] = array( 'attribute' => $attribute, 'name' => $name ) ;
				
				continue ;
			}
			
			switch ( $command ) {
				case 'fake' :
				case 'remove' :
				case 'dummy' :
					$commands[ 'fake' ] = true ;
					break ;
				
				case 'record' :
				case 'parse_outer' :
				case 'parse_inner' :
				case 'outer' :
				case 'inner' :
				case 'text' :
				case 'textarea' :
					$commands[ $command ] = $name ;
					break ;
				
				case 'pre' :
					$commands[ 'textarea' ] = $name ;
					break ;
				
				case 'if' :
				case 'else' :
				case 'condition' :
				case 'condition_not' :
					$condition = ( ( $command == 'if' ) or ( $command == 'condition' ) ) ;
					
					if ( ! isset( $commands[ 'condition' ] ) ) $commands[ 'condition' ] =  array() ;
					$commands[ 'condition' ][] = array( 'condition' => $condition, 'name' => $name ) ;
					
					break ;
				
				default :
					if ( ! isset( $commands[ 'other' ] ) ) $commands[ 'other' ] =  array() ;
					$commands[ 'other' ][] = array( 'command' => $command, 'name' => $name ) ;
			}
		}
		
		return $commands ;
	}
	
	
	function _get_template_contents( &$data, $name ) {
		if ( mb_ereg( '\Aurl\(([^)]*)\)\z', $name, $match ) ) {
			$parts = array() ;
			$urls = mb_split( '(\s+|\s*,\s*)', $match[ 1 ] ) ;
			
			for ( $n = 0 ; $n < count( $urls ) ; $n++ ) {
				$url = trim( $urls[ $n ] ) ;
				
				if ( $url == '' ) continue ;
				
				$part = @file_get_contents( $url ) ;
				if ( $part === false ) return false ;
				
				$parts[] = rtrim( $this->delete_bom( $part ) ) ;
			}
			
			return implode( "\n", $parts ) ;
		}
		
		return $this->_get_template_value( $data, $name ) ;
	}
	
	
	function _get_template_value( &$data, $name ) {
		list( $local, $localName ) = $this->_get_template_value_local( $data, $name ) ;
		
		if ( ! isset( $local[ 'value' ][ $localName ] ) ) {
			return false ;
		}
		
		return $local[ 'value' ][ $localName ] ;
	}
	
	
	function _get_template_value_local( &$data, $name ) {
		if ( mb_ereg( '\A([^\.]+?)\.(.+)\z', $name, $match ) ) {
			switch ( strtolower( trim( $match[ 1 ] ) ) ) {
				case 'root' :
					return array( $data[ 'root' ], trim( $match[ 2 ] ) ) ;
					break ;
				
				case 'parent' :
					return array( $data[ 'parent' ], trim( $match[ 2 ] ) ) ;
					break ;
			}
		}
		
		return array( $data, $name ) ;
	}
	
	
	function _inner_keep_indent( &$element, $html ) {
		if ( $element->childNodes->length == 0 ) {
			return $html ;
		}
		
		$first = '' ;
		$last = '' ;
		
		// 開始タグの後の改行までの空白・コメントを保持
		
		while ( $element->childNodes->length > 0 ) {
			if ( $element->firstChild->nodeType == XML_TEXT_NODE ) {
				$text = $element->firstChild->nodeValue ;
				
				// 改行がある場合(終了)
				
				if ( mb_ereg( '\A(.*?)(\r?\n)(.*)\z', $text, $match ) ) {
					$space = $match[ 1 ] ;
					$lf = $match[ 2 ] ;
					$other = $match[ 3 ] ;
					
					if ( mb_ereg( '\A\s*\z', $space ) ) {
						$first = "{$first}{$space}{$lf}" ;
						$element->firstChild->nodeValue = "{$lf}{$other}" ;
					} else {
						$first = "{$first}{$lf}" ;
					}
					
					break ;
				}
				
				// 空白でない場合(終了)
				
				if ( ! mb_ereg( '\A\s*\z', $text ) ) {
					break ;
				}
				
				// 空白を保持
				
				$first = "{$first}{$text}" ;
				$element->removeChild( $element->firstChild ) ;
				
				continue ;
			}
			
			# コメントを保持
			
			if ( $element->firstChild->nodeType == XML_COMMENT_NODE ) {
				$first = "{$first}<!--" . $element->firstChild->nodeValue . "-->" ;
				$element->removeChild( $element->firstChild ) ;
				
				continue ;
			}
			
			break ;
		}
		
		// 閉じタグのインデントを保持
		
		while ( $element->childNodes->length > 0 ) {
			if ( $element->lastChild->nodeType == XML_TEXT_NODE ) {
				$text = $element->lastChild->nodeValue ;
				
				// 改行がある場合(終了)
				
				if ( mb_ereg( '\A(.*)(\r?\n)(.*?)\z', $text, $match ) ) {
					$other = $match[ 1 ] ;
					$lf = $match[ 2 ] ;
					$space = $match[ 3 ] ;
					
					if ( mb_ereg( '\A\s*\z', $space ) ) {
						$last = "{$lf}{$space}{$last}" ;
						$element->lastChild->nodeValue = "{$other}{$lf}" ;
					} else {
						$last = "{$lf}{$last}" ;
					}
					
					break ;
				}
				
				// 空白でない場合(終了)
				
				if ( ! mb_ereg( '\A\s*\z', $text ) ) {
					break ;
				}
				
				// 空白を保持
				
				$last = "{$text}{$last}" ;
				$element->removeChild( $element->lastChild ) ;
				
				continue ;
			}
			
			// コメントを保持
			
			if ( $element->lastChild->nodeType == XML_COMMENT_NODE ) {
				$last = "<!--" . $element->lastChild->nodeValue . "-->{$last}" ;
				$element->removeChild( $element->lastChild ) ;
				
				continue ;
			}
			
			break ;
		}
		
		return "{$first}{$html}{$last}" ;
	}
}
?>